IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Servers' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Servers(Pc_Server	VARCHAR(50) NOT NULL,
							Descripcion VARCHAR(20) NULL,
							Ip			VARCHAR(15) NOT NULL,
							Puerto		SMALLINT NOT NULL,
							Observacion TEXT NULL)							
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Servers')
	
	IF(@Cant_Columnas <> 5)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Pc_Server'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Pc_Server VARCHAR(50) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Descripcion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Descripcion VARCHAR(20) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Ip'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Ip VARCHAR(15) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Puerto'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Puerto SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Pc_Server'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Pc_Server VARCHAR(50) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Servers' AND Column_Name = 'Observacion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Servers ADD Observacion TEXT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Servers_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Servers_SuperArreglo
	FROM CD_Servers
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDSRV_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Servers')
BEGIN
	ALTER TABLE CD_Servers ADD CONSTRAINT PK_CDSRV_PorId PRIMARY KEY (Pc_Server)
END


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDSRV_PorDescripcion')
BEGIN
	CREATE UNIQUE INDEX IX_CDSRV_PorDescripcion ON CD_Servers (Descripcion)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos(Id_Acceso			SMALLINT NOT NULL,
							Descripcion			VARCHAR(20) NOT NULL,
							Pc_Server			VARCHAR(50) NOT NULL,
							Flag_AntiPassBack	TINYINT NULL,
							Observacion			TEXT NULL,
							Flag_Ult_Cuota_Paga TINYINT NULL,
							Dias_Gracia			INT NULL,
							Tiempo_Semaforo		SMALLINT NULL,
							Tiempo_Mensaje		SMALLINT NULL,
							Tiempo_Foto			SMALLINT NULL,
							Tiempo_Mensaje_Error SMALLINT NULL,
							Estado				CHAR(1) NULL,
							Flag_Evento			TINYINT NULL,
							Fecha_LB			DATETIME NULL,
							Tiempo_Antirebote	INT NULL)							
		
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos')
	
	IF(@Cant_Columnas <> 15)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Descripcion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Descripcion VARCHAR(20) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Pc_Server'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Pc_Server VARCHAR(50) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Flag_AntiPassBack'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Flag_AntiPassBack TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Observacion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Observacion TEXT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Flag_Ult_Cuota_Paga'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Flag_Ult_Cuota_Paga TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Dias_Gracia'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Dias_Gracia INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Tiempo_Semaforo'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Tiempo_Semaforo SMALLINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Tiempo_Mensaje'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Tiempo_Mensaje SMALLINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Tiempo_Foto'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Tiempo_Foto SMALLINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Tiempo_Mensaje_Error'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Tiempo_Mensaje_Error SMALLINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Estado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Estado CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Flag_Evento'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Flag_Evento TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Fecha_LB'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Fecha_LB	DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos' AND Column_Name = 'Tiempo_Antirebote'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos ADD Tiempo_Antirebote INT NULL
		END
				
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_SuperArreglo
	FROM CD_Accesos
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CD_Acc' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Mult DROP CONSTRAINT FK_CDACM_CD_Accesos
	ALTER TABLE CD_Accesos_Mult DROP CONSTRAINT FK_CDACMP_CD_Accesos
	ALTER TABLE CD_Accesos_Pc DROP CONSTRAINT FK_CDACPC_CD_Accesos
	ALTER TABLE CD_Accesos_Pc_Visitas DROP CONSTRAINT CDAPV_CD_Accesos
	ALTER TABLE CD_Accesos_Prod DROP CONSTRAINT FK_CDACP_CD_Accesos
	ALTER TABLE CD_Accesos_Venc DROP CONSTRAINT FK_CDAV_CD_Accesos
	ALTER TABLE CD_Controladores DROP CONSTRAINT FK_CDCO_CD_Accesos
	ALTER TABLE CD_Es DROP CONSTRAINT FK_CDES_CD_Accesos
	ALTER TABLE CD_Huellas_Leidas DROP CONSTRAINT FK_CDHL_CD_Accesos
	ALTER TABLE CD_Accesos_Tags DROP CONSTRAINT FK_CDAT_Cd_Accesos
	ALTER TABLE CD_Accesos_Cli_Tipos DROP CONSTRAINT FK_CDACT_CD_Accesos
	ALTER TABLE CD_Accesos_Cont_Tipos DROP CONSTRAINT FK_CDACCT_CD_Accesos
	ALTER TABLE CD_Accesos_Eventos DROP CONSTRAINT FK_CDACEV_CD_Accesos
	ALTER TABLE CD_Accesos_Horarios DROP CONSTRAINT FK_CDHorarios_Accesos	
	ALTER TABLE CD_Accesos DROP CONSTRAINT PK_CD_Acc
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAC_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos ADD CONSTRAINT PK_CDAC_PorId PRIMARY KEY (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAC_CD_Servers')
BEGIN
	ALTER TABLE CD_Accesos ADD CONSTRAINT FK_CDAC_CD_Servers FOREIGN KEY (Pc_Server) REFERENCES CD_Servers (Pc_Server)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAC_PorDescripcion')
BEGIN
	CREATE UNIQUE INDEX IX_CDAC_PorDescripcion ON CD_Accesos (Descripcion)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAC_PorPc')
BEGIN
	CREATE UNIQUE INDEX IX_CDAC_PorPc ON CD_Accesos (Pc_Server, Descripcion, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Cli_Tipos' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Cli_Tipos	(Id_Acceso		SMALLINT NOT NULL,
										Id_Tipo_Cli		SMALLINT NOT NULL,
										Flag_Habilitado CHAR(1) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cli_Tipos')
	
	IF(@Cant_Columnas <> 3)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cli_Tipos' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cli_Tipos ADD Id_Acceso SMALLINT NOT NULL
		END
		
			SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cli_Tipos' AND Column_Name = 'Id_Tipo_Cli'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cli_Tipos ADD Id_Tipo_Cli SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cli_Tipos' AND Column_Name = 'Flag_Habilitado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cli_Tipos ADD Flag_Habilitado CHAR(1) NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Cli_Tipos_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Cli_Tipos_SuperArreglo
	FROM CD_Accesos_Cli_Tipos
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACT_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Cli_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Cli_Tipos ADD CONSTRAINT PK_CDACT_PorId PRIMARY KEY (Id_Acceso, Id_Tipo_Cli)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACT_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Cli_Tipos ADD CONSTRAINT FK_CDACT_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACT_Clientes_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Cli_Tipos ADD CONSTRAINT FK_CDACT_Clientes_Tipos FOREIGN KEY (Id_Tipo_Cli) REFERENCES Clientes_Tipos (Id_Tipo_Cli)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDACT_PorTipo')
BEGIN
	CREATE UNIQUE INDEX IX_CDACT_PorTipo ON CD_Accesos_Cli_Tipos (Id_Tipo_Cli, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Cont_Tipos' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Cont_Tipos	(Id_Acceso SMALLINT NOT NULL,
										Id_Tipo_Con SMALLINT NOT NULL,
										Flag_Habilitado CHAR(1) NULL,
										Dias_Aviso INT NULL,
										Observacion_Prox_Venc VARCHAR(200) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos')
	
	IF(@Cant_Columnas <> 5)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cont_Tipos ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos' AND Column_Name = 'Id_Tipo_Con'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cont_Tipos ADD Id_Tipo_Con SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos' AND Column_Name = 'Flag_Habilitado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cont_Tipos ADD Flag_Habilitado CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos' AND Column_Name = 'Dias_Aviso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cont_Tipos ADD Dias_Aviso INT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Cont_Tipos' AND Column_Name = 'Observacion_Prox_Venc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Cont_Tipos ADD Observacion_Prox_Venc VARCHAR(200) NULL
		END		
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Cont_Tipos_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Cont_Tipos_SuperArreglo
	FROM CD_Accesos_Cont_Tipos
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACCT_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Cont_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Cont_Tipos ADD CONSTRAINT PK_CDACCT_PorId PRIMARY KEY (Id_Acceso, Id_Tipo_Con)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACCT_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Cont_Tipos ADD CONSTRAINT FK_CDACCT_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACCT_Contratos_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Cont_Tipos ADD CONSTRAINT FK_CDACCT_Contratos_Tipos FOREIGN KEY (Id_Tipo_Con) REFERENCES Contratos_Tipos (Id_Tipo_Con)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDACCT_PorTipo')
BEGIN
	CREATE UNIQUE INDEX IX_CDACCT_PorTipo ON CD_Accesos_Cont_Tipos (Id_Tipo_Con, Id_Acceso)
END

GO
/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Eventos' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Eventos	(Id_Acceso		SMALLINT NOT NULL,
									Id_Lista_Precio SMALLINT NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Eventos')
	
	IF(@Cant_Columnas <> 2)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Eventos' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Eventos ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Eventos' AND Column_Name = 'Id_Lista_Precio'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Eventos ADD Id_Lista_Precio SMALLINT NOT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Eventos_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Eventos_SuperArreglo
	FROM CD_Accesos_Eventos
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACEV_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Eventos')
BEGIN
	ALTER TABLE CD_Accesos_Eventos ADD CONSTRAINT PK_CDACEV_PorId PRIMARY KEY (Id_Acceso, Id_Lista_Precio)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACEV_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Eventos ADD CONSTRAINT FK_CDACEV_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACEV_Prod_Listas_Precios')
BEGIN
	ALTER TABLE CD_Accesos_Eventos ADD CONSTRAINT FK_CDACEV_Prod_Listas_Precios FOREIGN KEY (Id_Lista_Precio) REFERENCES Prod_Listas_Precios (Id_Lista_Precio)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDACEV_PorEve')
BEGIN
	CREATE UNIQUE INDEX IX_CDACEV_PorEve ON CD_Accesos_Eventos (Id_Lista_Precio, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Horarios' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Horarios	(Id_Horario INT NOT NULL,
										Id_Acceso	SMALLINT NOT NULL,
										Id_Producto VARCHAR(14) NOT NULL,
										Id_Tipo_Cli SMALLINT NOT NULL,
										Dia			TINYINT NULL,
										Hora_Desde	DATETIME NULL,
										Hora_Hasta	DATETIME NULL,
										Nota		TEXT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios')
	
	IF(@Cant_Columnas <> 8)
	BEGIN
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Id_Horario'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Id_Horario INT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Id_Producto'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Id_Producto VARCHAR(14) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Id_Tipo_Cli'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Id_Tipo_Cli SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Dia'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Dia	TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Hora_Desde'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Hora_Desde DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Hora_Hasta'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Hora_Hasta DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Horarios' AND Column_Name = 'Nota'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Horarios ADD Nota TEXT NULL
		END
														
	END
END	

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Horarios_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Horarios_SuperArreglo
	FROM CD_Accesos_Horarios
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_Id_Horario' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Horarios')
BEGIN
	ALTER TABLE CD_Accesos_Horarios DROP CONSTRAINT PK_Id_Horario
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAH_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Horarios')
BEGIN
	ALTER TABLE CD_Accesos_Horarios ADD CONSTRAINT PK_CDAH_PorId PRIMARY KEY (Id_Horario)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAH_CD_Accesos_Horarios')
BEGIN
	ALTER TABLE CD_Accesos_Horarios ADD CONSTRAINT FK_CDAH_CD_Accesos_Horarios FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDHorarios_Productos')
BEGIN
	ALTER TABLE CD_Accesos_Horarios DROP CONSTRAINT FK_CDHorarios_Productos
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAH_Productos')
BEGIN
	ALTER TABLE CD_Accesos_Horarios ADD CONSTRAINT FK_CDAH_Productos FOREIGN KEY (Id_Producto) REFERENCES Productos (Id_Producto)
END

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDHorarios_Clientes_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Horarios DROP CONSTRAINT FK_CDHorarios_Clientes_Tipos
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAH_Clientes_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Horarios ADD CONSTRAINT FK_CDAH_Clientes_Tipos FOREIGN KEY (Id_Tipo_Cli) REFERENCES Clientes_Tipos (Id_Tipo_Cli)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAH_PorProd')
BEGIN
	CREATE UNIQUE INDEX IX_CDAH_PorProd ON CD_Accesos_Horarios (Id_Producto, Id_Horario)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAH_PorTipo')
BEGIN
	CREATE UNIQUE INDEX IX_CDAH_PorTipo ON CD_Accesos_Horarios (Id_Tipo_Cli, Id_Horario)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAH_PorAcc')
BEGIN
	CREATE UNIQUE INDEX IX_CDAH_PorAcc ON CD_Accesos_Horarios (Id_Acceso, Id_Tipo_Cli, Id_Producto, Dia, Hora_Desde)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Mult' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Mult	(Id_Acceso_Padre	SMALLINT NOT NULL,
									Id_Acceso			SMALLINT NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Mult')
	
	IF(@Cant_Columnas <> 2)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Mult' AND Column_Name = 'Id_Acceso_Padre'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Mult ADD Id_Acceso_Padre SMALLINT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Mult' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Mult ADD Id_Acceso SMALLINT NOT NULL
		END														
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Mult_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Mult_SuperArreglo
	FROM CD_Accesos_Mult
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACM_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Mult')
BEGIN
	ALTER TABLE CD_Accesos_Mult ADD CONSTRAINT PK_CDACM_PorId PRIMARY KEY (Id_Acceso_Padre, Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACM_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Mult ADD CONSTRAINT FK_CDACM_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACM_CD_Accesos_Padre')
BEGIN
	ALTER TABLE CD_Accesos_Mult ADD CONSTRAINT FK_CDACM_CD_Accesos_Padre FOREIGN KEY (Id_Acceso_Padre) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDACM_PorHijo')
BEGIN
	CREATE UNIQUE INDEX IX_CDACM_PorHijo ON CD_Accesos_Mult (Id_Acceso_Padre, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Pc' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Pc	(Id_Acceso	SMALLINT NOT NULL,
								Pc			VARCHAR(50) NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc')
	
	IF(@Cant_Columnas <> 2)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Pc ADD Id_Acceso SMALLINT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc' AND Column_Name = 'Pc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Pc ADD Pc VARCHAR(50) NOT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Pc_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Pc_SuperArreglo
	FROM CD_Accesos_Pc
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACPC_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Pc')
BEGIN
	ALTER TABLE CD_Accesos_Pc ADD CONSTRAINT PK_CDACPC_PorId PRIMARY KEY (Id_Acceso, Pc)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACPC_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Pc ADD CONSTRAINT FK_CDACPC_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Pc_Visitas' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Pc_Visitas	(Id_Acceso	SMALLINT NOT NULL,
										Pc			VARCHAR(50) NOT NULL,
										Descripcion VARCHAR(100) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc_Visitas')
	
	IF(@Cant_Columnas <> 3)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc_Visitas' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Pc_Visitas ADD Id_Acceso SMALLINT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc_Visitas' AND Column_Name = 'Pc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Pc_Visitas ADD Pc VARCHAR(50) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Pc_Visitas' AND Column_Name = 'Descripcion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Pc_Visitas ADD Descripcion VARCHAR(100) NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Pc_Visitas_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Pc_Visitas_SuperArreglo
	FROM CD_Accesos_Pc_Visitas
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAPV_Acc' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Pc_Visitas')
BEGIN
	ALTER TABLE CD_Accesos_Pc_Visitas DROP CONSTRAINT PK_CDAPV_Acc
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAPV_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Pc_Visitas')
BEGIN
	ALTER TABLE CD_Accesos_Pc_Visitas ADD CONSTRAINT PK_CDAPV_PorId PRIMARY KEY (Id_Acceso, Pc)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAPV_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Pc_Visitas ADD CONSTRAINT FK_CDAPV_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAPV_PorDes')
BEGIN
	CREATE UNIQUE INDEX IX_CDAPV_PorDes ON CD_Accesos_Pc_Visitas (Descripcion)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Prod' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Prod		(Id_Acceso			SMALLINT NOT NULL,
										Id_Producto			VARCHAR(14) NOT NULL,
										Dias_Gracia			INT NULL,
										Valida_En_Titular	TINYINT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Prod')
	
	IF(@Cant_Columnas <> 4)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Prod' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Prod ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Prod' AND Column_Name = 'Id_Producto'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Prod ADD Id_Producto	VARCHAR(14) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Prod' AND Column_Name = 'Dias_Gracia'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Prod ADD Dias_Gracia	INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Prod' AND Column_Name = 'Valida_En_Titular'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Prod ADD Valida_En_Titular TINYINT NULL
		END						
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Prod_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Prod_SuperArreglo
	FROM CD_Accesos_Prod
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDACP_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Prod')
BEGIN
	ALTER TABLE CD_Accesos_Prod ADD CONSTRAINT PK_CDACP_PorId PRIMARY KEY (Id_Acceso, Id_Producto)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACP_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Prod ADD CONSTRAINT FK_CDACP_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDACP_Productos')
BEGIN
	ALTER TABLE CD_Accesos_Prod ADD CONSTRAINT FK_CDACP_Productos FOREIGN KEY (Id_Producto) REFERENCES Productos (Id_Producto)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDACP_PorDes')
BEGIN
	CREATE UNIQUE INDEX IX_CDACP_PorDes ON CD_Accesos_Prod (Id_Producto, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Tags' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Tags	(Id_Acceso	SMALLINT NOT NULL,
									Id_Tag		VARCHAR(20) NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Tags')
	
	IF(@Cant_Columnas <> 2)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Tags' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Tags ADD Id_Acceso SMALLINT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Tags' AND Column_Name = 'Id_Tag'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Tags ADD Id_Tag VARCHAR(20) NOT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Tags_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Tags_SuperArreglo
	FROM CD_Accesos_Tags
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_Cd_Accesos_Tags' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Tags')
BEGIN
	ALTER TABLE CD_Accesos_Tags DROP CONSTRAINT PK_Cd_Accesos_Tags
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAT_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Tags')
BEGIN
	ALTER TABLE CD_Accesos_Tags ADD CONSTRAINT PK_CDAT_PorId PRIMARY KEY (Id_Acceso, Id_Tag)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAT_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Tags ADD CONSTRAINT FK_CDAT_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Accesos_Venc' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Accesos_Venc	(Id_Acceso				SMALLINT NOT NULL,
									Id_Tipo_Venc			VARCHAR(10) NOT NULL,
									Dias_Aviso				INT NULL,
									Observacion_Prox_Venc	VARCHAR(200) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Venc')
	
	IF(@Cant_Columnas <> 4)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Venc' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Venc ADD Id_Acceso SMALLINT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Venc' AND Column_Name = 'Id_Tipo_Venc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Venc ADD Id_Tipo_Venc VARCHAR(10) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Venc' AND Column_Name = 'Dias_Aviso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Venc ADD Dias_Aviso INT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Accesos_Venc' AND Column_Name = 'Observacion_Prox_Venc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Accesos_Venc ADD Observacion_Prox_Venc VARCHAR(200) NULL
		END				
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Accesos_Venc_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Accesos_Venc_SuperArreglo
	FROM CD_Accesos_Venc
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDAV_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Accesos_Venc')
BEGIN
	ALTER TABLE CD_Accesos_Venc ADD CONSTRAINT PK_CDAV_PorId PRIMARY KEY (Id_Acceso, Id_Tipo_Venc)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAV_CD_Accesos')
BEGIN
	ALTER TABLE CD_Accesos_Venc ADD CONSTRAINT FK_CDAV_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDAV_Clientes_Venc_Tipos')
BEGIN
	ALTER TABLE CD_Accesos_Venc ADD CONSTRAINT FK_CDAV_Clientes_Venc_Tipos FOREIGN KEY (Id_Tipo_Venc) REFERENCES Clientes_Venc_Tipos (Id_Tipo_Venc)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDAV_PorVenc')
BEGIN
	CREATE UNIQUE INDEX IX_CDAV_PorVenc ON CD_Accesos_Venc (Id_Tipo_Venc, Id_Acceso)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Cli_Master' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Cli_Master	(Id_Cliente INT NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Cli_Master')
	
	IF(@Cant_Columnas <> 1)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Cli_Master' AND Column_Name = 'Id_Cliente'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Cli_Master ADD Id_Cliente INT NOT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Cli_Master_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Cli_Master_SuperArreglo
	FROM CD_Cli_Master
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDCM_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Cli_Master')
BEGIN
	ALTER TABLE CD_Cli_Master ADD CONSTRAINT PK_CDCM_PorId PRIMARY KEY (Id_Cliente)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDCM_Clientes')
BEGIN
	ALTER TABLE CD_Cli_Master ADD CONSTRAINT FK_CDCM_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Controladores' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Controladores	(Id_Acceso					SMALLINT NOT NULL,
									Id_Controlador				SMALLINT NOT NULL,
									Nro_Serie					VARCHAR(30) NOT NULL,
									Server						VARCHAR(254) NULL,
									Ent_Lector					TINYINT NULL,
									Ent_Lector_HD				VARCHAR(50) NULL,
									Ent_Comando					VARCHAR(250) NULL,
									Ent_Relay					TINYINT NULL,
									Sal_Lector					TINYINT NULL,
									Sal_Lector_HD				VARCHAR(50) NULL,
									Sal_Comando					VARCHAR(250) NULL,
									Sal_Relay					TINYINT NULL,
									Port						INT NULL,
									In_Active_Timeout			INT NULL,
									Asynchronous_Timeout		INT NULL,
									Asynchronous_Open			TINYINT NULL,
									Observacion					TEXT NULL,
									Tipo_Cont					CHAR(1) NULL,
									Tipo						CHAR(1) NULL,
									Descripcion					VARCHAR(100) NOT NULL,
									Ent_Com						INT NULL,
									Ent_Baud_Rates				INT NULL,
									Ent_Data_Bits				TINYINT NULL,
									Ent_Parity					CHAR(1) NULL,
									Ent_Stop_Bit				DECIMAL(2, 1) NULL,
									Ent_Flow_Control			CHAR(1) NULL,
									Sal_Com						INT NULL,
									Sal_Baud_Rates				INT NULL,
									Sal_Data_Bits				TINYINT NULL,
									Sal_Parity					CHAR(1) NULL,
									Sal_Stop_Bit				DECIMAL(2, 1) NULL,
									Sal_Flow_Control			CHAR(1) NULL,
									Baud_Rates					INT NULL,
									Data_Bits					TINYINT NULL,
									Parity						CHAR(1) NULL,
									Stop_Bit					DECIMAL(2, 1) NULL,
									Flow_Control				CHAR(1) NULL,
									Tipo_Reg_Paso				CHAR(1) NULL,
									Estado						CHAR(1) NULL,
									Id_Controlador_2			SMALLINT NULL,
									Ent_Com_Tipo_Lector			CHAR(1) NULL,
									Sal_Com_Tipo_Lector			CHAR(1) NULL,
									Ent_Com_Frecuencia_Lect		SMALLINT NULL,
									Sal_Com_Frecuencia_Lect		SMALLINT NULL,
									Ult_IP						VARCHAR(20) NULL,
									Ult_Estado					VARCHAR(50) NULL,
									Flag_Memoria_Ent_Lector_HD	TINYINT NULL,
									Flag_Memoria_Sal_Lector_HD	TINYINT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Controladores')
	
	IF(@Cant_Columnas <> 48)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Id_Acceso SMALLINT NOT NULL 
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Id_Controlador'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Id_Controlador SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Nro_Serie'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Nro_Serie VARCHAR(30) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Server'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Server VARCHAR(254) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Lector'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Lector TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Lector_HD'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Lector_HD VARCHAR(50) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Comando'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Comando VARCHAR(250) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Relay'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Relay TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Lector'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Lector TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Lector_HD'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Lector_HD VARCHAR(50) NULL
		END																
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Comando'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Comando VARCHAR(250) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Relay'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Relay TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Port'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Port INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'In_Active_Timeout'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD In_Active_Timeout INT NULL
		END
				
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Asynchronous_Timeout'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Asynchronous_Timeout INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Asynchronous_Open'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Asynchronous_Open TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Observacion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Observacion TEXT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Tipo_Cont'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Tipo_Cont CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Tipo'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Tipo CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Descripcion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Descripcion VARCHAR(100) NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Com'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Com INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Baud_Rates'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Baud_Rates INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Data_Bits'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Data_Bits TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Parity'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Parity CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Stop_Bit'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Stop_Bit DECIMAL(2, 1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Flow_Control'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Flow_Control CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Com'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Com INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Baud_Rates'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Baud_Rates INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Data_Bits'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Data_Bits TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Parity'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Parity CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Stop_Bit'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Stop_Bit DECIMAL(2, 1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Flow_Control'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Flow_Control CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Baud_Rates'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Baud_Rates INT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Data_Bits'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Data_Bits TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Parity'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Parity CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Stop_Bit'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Stop_Bit DECIMAL(2, 1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Flow_Control'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Flow_Control CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Tipo_Reg_Paso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Tipo_Reg_Paso CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Estado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Estado CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Id_Controlador_2'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Id_Controlador_2 SMALLINT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Com_Tipo_Lector'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Com_Tipo_Lector CHAR(1) NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Com_Tipo_Lector'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Com_Tipo_Lector CHAR(1) NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ent_Com_Frecuencia_Lect'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ent_Com_Frecuencia_Lect SMALLINT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Sal_Com_Frecuencia_Lect'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Sal_Com_Frecuencia_Lect SMALLINT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ult_IP'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ult_IP VARCHAR(20) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Ult_Estado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Ult_Estado VARCHAR(50) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Flag_Memoria_Ent_Lector_HD'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Flag_Memoria_Ent_Lector_HD TINYINT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Controladores' AND Column_Name = 'Flag_Memoria_Sal_Lector_HD'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Controladores ADD Flag_Memoria_Sal_Lector_HD TINYINT NULL
		END				
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Controladores_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Controladores_SuperArreglo
	FROM CD_Controladores
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_Cd_Cont' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Controladores')
BEGIN
	ALTER TABLE CD_Huellas_Leidas DROP CONSTRAINT FK_CDHL_CD_Control
	ALTER TABLE CD_ES DROP CONSTRAINT FK_CDES_CD_Control
	ALTER TABLE CD_Controladores DROP CONSTRAINT FK_CDCO_CD_Controladores
	ALTER TABLE CD_Controladores DROP CONSTRAINT PK_Cd_Cont
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDCO_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Controladores')
BEGIN
	ALTER TABLE CD_Controladores ADD CONSTRAINT PK_CDCO_PorId PRIMARY KEY (Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDCO_Cd_Accesos')
BEGIN
	ALTER TABLE CD_Controladores ADD CONSTRAINT FK_CDCO_Cd_Accesos FOREIGN KEY (Id_Acceso) REFERENCES Cd_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDCO_Controladores_2')
BEGIN
	ALTER TABLE CD_Controladores ADD CONSTRAINT FK_CDCO_Controladores_2 FOREIGN KEY (Id_Controlador_2) REFERENCES Cd_Controladores (Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDCO_PorId2')
BEGIN
	CREATE UNIQUE INDEX IX_CDCO_PorId2 ON CD_Controladores (Id_Controlador_2, Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDCO_PorDesc')
BEGIN
	CREATE UNIQUE INDEX IX_CDCO_PorDesc ON CD_Controladores (Descripcion, Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDCO_PorSerie')
BEGIN
	CREATE UNIQUE INDEX IX_CDCO_PorSerie ON CD_Controladores (Nro_Serie)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Enrol_Pc' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Enrol_Pc	(Pc		VARCHAR(50) NOT NULL,
								Lector	VARCHAR(100) NOT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Enrol_Pc')
	
	IF(@Cant_Columnas <> 2)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Enrol_Pc' AND Column_Name = 'Pc'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Enrol_Pc ADD Pc VARCHAR(50) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Enrol_Pc' AND Column_Name = 'Lector'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Enrol_Pc ADD Lector	VARCHAR(100) NOT NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Enrol_Pc_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Enrol_Pc_SuperArreglo
	FROM CD_Enrol_Pc
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDEPC_PorPc' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Enrol_Pc')
BEGIN
	ALTER TABLE CD_Enrol_Pc DROP CONSTRAINT PK_CDEPC_PorPc
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDEPC_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Enrol_Pc')
BEGIN
	ALTER TABLE CD_Enrol_Pc ADD CONSTRAINT PK_CDEPC_PorId PRIMARY KEY (Pc, Lector)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_ES' AND Xtype='U')
BEGIN
	CREATE TABLE CD_ES	(Id_ES			INT IDENTITY(1,1) NOT NULL,
						Tipo			CHAR(1) NULL,
						Origen			CHAR(1) NULL,
						Id_Tarjeta		VARCHAR(50) NULL,
						Id_Cliente		INT NOT NULL,
						Fecha			DATETIME NULL,
						Resultado		CHAR(1) NULL,
						Id_Controlador	SMALLINT NOT NULL,
						Id_Acceso		SMALLINT NOT NULL,
						Observacion		TEXT NULL,
						Tipo_Reg		CHAR(5) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_ES')
	
	IF(@Cant_Columnas <> 11)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Id_ES'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Id_ES	INT IDENTITY(1,1) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Tipo'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Tipo CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Origen'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Origen CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Id_Tarjeta'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Id_Tarjeta VARCHAR(50) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Id_Cliente'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Id_Cliente INT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Fecha'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Fecha	DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Resultado'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Resultado	CHAR(1) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Id_Controlador'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Id_Controlador SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Id_Acceso	SMALLINT NOT NULL
		END		
				
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Observacion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Observacion TEXT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_ES' AND Column_Name = 'Tipo_Reg'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_ES ADD Tipo_Reg CHAR(5) NULL
		END																		
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_ES_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_ES_SuperArreglo
	FROM CD_ES
END

IF EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CD_ES' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_ES')
BEGIN
	ALTER TABLE CD_ES DROP CONSTRAINT PK_CD_ES
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDES_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_ES')
BEGIN
	ALTER TABLE CD_ES ADD CONSTRAINT PK_CDES_PorId PRIMARY KEY (Id_ES)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDES_Clientes')
BEGIN
	ALTER TABLE CD_ES ADD CONSTRAINT FK_CDES_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDES_CD_Controladores')
BEGIN
	ALTER TABLE CD_ES ADD CONSTRAINT FK_CDES_CD_Controladores FOREIGN KEY (Id_Controlador) REFERENCES CD_Controladores (Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDES_CD_Accesos')
BEGIN
	ALTER TABLE CD_ES ADD CONSTRAINT FK_CDES_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDES_PorCli')
BEGIN
	CREATE UNIQUE INDEX IX_CDES_PorCli ON CD_ES (Id_Cliente, Fecha, Id_Es)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDES_PorCont')
BEGIN
	CREATE UNIQUE INDEX IX_CDES_PorCont ON CD_ES (Id_Controlador, Id_Acceso, Fecha, Id_Es)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDES_PorFecha')
BEGIN
	CREATE UNIQUE INDEX IX_CDES_PorFecha ON CD_ES (Fecha, Id_Es)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDES_PorTar')
BEGIN
	CREATE UNIQUE INDEX IX_CDES_PorTar ON CD_ES (Id_Tarjeta, Fecha, Id_Es)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Huellas_Leidas' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Huellas_Leidas	(Id_Huella_Leida	INT IDENTITY(1,1) NOT NULL,
									Fecha				DATETIME NULL,
									Flag_OK				TINYINT NULL,
									Id_Cliente			INT NULL,
									Tipo				CHAR(1) NULL,
									Id_Acceso			SMALLINT NULL,
									Id_Controlador		SMALLINT NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas')
	
	IF(@Cant_Columnas <> 7)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Id_Huella_Leida'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Id_Huella_Leida INT IDENTITY(1,1) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Fecha'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Fecha	DATETIME NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Flag_OK'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Flag_OK TINYINT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Id_Cliente'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Id_Cliente INT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Tipo'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Tipo CHAR(1) NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Id_Acceso	SMALLINT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Huellas_Leidas' AND Column_Name = 'Id_Controlador'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Huellas_Leidas ADD Id_Controlador SMALLINT NULL
		END								
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Huellas_Leidas_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Huellas_Leidas_SuperArreglo
	FROM CD_Huellas_Leidas
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDHL_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Huellas_Leidas')
BEGIN
	ALTER TABLE CD_Huellas_Leidas ADD CONSTRAINT PK_CDHL_PorId PRIMARY KEY (Id_Huella_Leida)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDHL_Clientes')
BEGIN
	ALTER TABLE CD_Huellas_Leidas ADD CONSTRAINT FK_CDHL_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDHL_CD_Accesos')
BEGIN
	ALTER TABLE CD_Huellas_Leidas ADD CONSTRAINT FK_CDHL_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDHL_CD_Controladores')
BEGIN
	ALTER TABLE CD_Huellas_Leidas ADD CONSTRAINT FK_CDHL_CD_Controladores FOREIGN KEY (Id_Controlador) REFERENCES CD_Controladores (Id_Controlador)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDHL_PorCli')
BEGIN
	CREATE UNIQUE INDEX IX_CDHL_PorCli ON CD_Huellas_Leidas (Id_Cliente, Fecha, Id_Huella_Leida)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDHL_PorCont')
BEGIN
	CREATE UNIQUE INDEX IX_CDHL_PorCont ON CD_Huellas_Leidas (Id_Controlador, Id_Huella_Leida)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDHL_PorAcc')
BEGIN
	CREATE UNIQUE INDEX IX_CDHL_PorAcc ON CD_Huellas_Leidas (Id_Acceso, Id_Huella_Leida)
END


GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Lista_Blanca' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Lista_Blanca	(Id_Acceso				SMALLINT NOT NULL,
									Fecha_Proceso			DATETIME NULL,
									Id_Formato				CHAR(1) NULL,
									Id_Cliente				INT NOT NULL,
									Razon_Social			VARCHAR(100) NULL,
									Credencial_Nro			VARCHAR(30) NULL,
									Credencial_Nro_Intelek	VARCHAR(30) NULL,
									Mensaje					VARCHAR(5000) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca')
	
	IF(@Cant_Columnas <> 8)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Id_Acceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Id_Acceso SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Fecha_Proceso'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Fecha_Proceso DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Id_Formato'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Id_Formato CHAR(1) NULL
		END		

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Id_Cliente'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Id_Cliente INT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Razon_Social'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Razon_Social VARCHAR(100) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Credencial_Nro'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Credencial_Nro VARCHAR(30) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Credencial_Nro_Intelek'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Credencial_Nro_Intelek	VARCHAR(30) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca' AND Column_Name = 'Mensaje'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca ADD Mensaje	VARCHAR(5000) NULL
		END								
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Lista_Blanca_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Lista_Blanca_SuperArreglo
	FROM CD_Accesos
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDLB_CD_Accesos')
BEGIN
	ALTER TABLE CD_Lista_Blanca ADD CONSTRAINT FK_CDLB_CD_Accesos FOREIGN KEY (Id_Acceso) REFERENCES CD_Accesos (Id_Acceso)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDLB_Clientes')
BEGIN
	ALTER TABLE CD_Lista_Blanca ADD CONSTRAINT FK_CDLB_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Lista_Blanca_Intelektron' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Lista_Blanca_Intelektron	(LB_Formato_Intelek VARCHAR(5143) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca_Intelektron')
	
	IF(@Cant_Columnas <> 1)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Lista_Blanca_Intelektron' AND Column_Name = 'LB_Formato_Intelek'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Lista_Blanca_Intelektron ADD LB_Formato_Intelek VARCHAR(5143) NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Lista_Blanca_Intelektron_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Lista_Blanca_Intelektron_SuperArreglo
	FROM CD_Lista_Blanca_Intelektron
END

GO 

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Log' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Log		(Id_Log		INT IDENTITY(1,1) NOT NULL,
							Tipo		CHAR(2) NULL,
							Fecha		DATETIME NULL,
							Descripcion VARCHAR(1000) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Log')
	
	IF(@Cant_Columnas <> 4)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Log' AND Column_Name = 'Id_Log'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Log ADD Id_Log INT IDENTITY(1,1) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Log' AND Column_Name = 'Tipo'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Log ADD Tipo CHAR(2) NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Log' AND Column_Name = 'Fecha'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Log ADD Fecha DATETIME NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Log' AND Column_Name = 'Descripcion'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Log ADD Descripcion VARCHAR(1000) NULL
		END
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Log_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Log_SuperArreglo
	FROM CD_Log
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDL_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Log')
BEGIN
	ALTER TABLE CD_Log ADD CONSTRAINT PK_CDL_PorId PRIMARY KEY (Id_Log)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDL_PorFec')
BEGIN
	CREATE UNIQUE INDEX IX_CDL_PorFec ON CD_Log (Fecha, Id_Log)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Personas_Rech' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Personas_Rech	(Id_Per_Rech	INT NOT NULL,
									Ape_Nom			VARCHAR(200) NULL,
									Apellido		VARCHAR(100) NULL,
									Nombre			VARCHAR(100) NULL,
									Doc_Nro			VARCHAR(20) NULL,
									Huella			VARBINARY(2000) NULL,
									Fecha_Alta		DATETIME NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech')
	
	IF(@Cant_Columnas <> 7)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Id_Per_Rech'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Id_Per_Rech INT NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Ape_Nom'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Ape_Nom VARCHAR(200) NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Apellido'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Apellido VARCHAR(100) NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Nombre'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Nombre VARCHAR(100) NULL
		END
		
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Doc_Nro'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Doc_Nro VARCHAR(20) NULL
		END
		
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Huella'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Huella	VARBINARY(2000) NULL
		END
		
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Personas_Rech' AND Column_Name = 'Fecha_Alta'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Personas_Rech ADD Fecha_Alta DATETIME NULL
		END				
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Personas_Rech_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Personas_Rech_SuperArreglo
	FROM CD_Personas_Rech
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDPR_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Personas_Rech')
BEGIN
	ALTER TABLE CD_Personas_Rech ADD CONSTRAINT PK_CDPR_PorId PRIMARY KEY (Id_Per_Rech)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDPR_PorApeNom')
BEGIN
	CREATE UNIQUE INDEX IX_CDPR_PorApeNom ON CD_Personas_Rech (Ape_Nom, Id_Per_Rech)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDPR_PorDoc')
BEGIN
	CREATE UNIQUE INDEX IX_CDPR_PorDoc ON CD_Personas_Rech (Doc_Nro, Id_Per_Rech)
END

GO

/*======================================================================================================================*/

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Tags' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Tags	(Id_Tag				VARCHAR(20) NOT NULL,
							Id_Lista_Precio		SMALLINT NOT NULL,
							Puerta				VARCHAR(100) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Tags')
	
	IF(@Cant_Columnas <> 3)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags' AND Column_Name = 'Id_Tag'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags ADD Id_Tag VARCHAR(20) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags' AND Column_Name = 'Id_Lista_Precio'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags ADD Id_Lista_Precio	SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags' AND Column_Name = 'Puerta'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags ADD Puerta VARCHAR(100) NULL
		END		
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Tags_SuperArreglo' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Tags_SuperArreglo
	FROM CD_Tags
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDT_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Tags')
BEGIN
	ALTER TABLE CD_Tags ADD CONSTRAINT PK_CDT_PorId PRIMARY KEY (Id_Tag)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDT_Prod_Listas_Precios')
BEGIN
	ALTER TABLE CD_Tags ADD CONSTRAINT FK_CDT_Prod_Listas_Precios FOREIGN KEY (Id_Lista_Precio) REFERENCES Prod_Listas_Precios (Id_Lista_Precio)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDT_PorEve')
BEGIN
	CREATE UNIQUE INDEX IX_CDT_PorEve ON CD_Tags (Id_Lista_Precio, Id_Tag)
END

GO

/*======================================================================================================================*/

IF EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Tags_Menor' AND Xtype='U')
BEGIN
	DROP TABLE CD_Tags_Menor
END
GO 

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='CD_Tags_Menor' AND Xtype='U')
BEGIN
	CREATE TABLE CD_Tags_Menor	(Id_Tag				VARCHAR(20) NOT NULL,
								Id_Lista_Precio		SMALLINT NOT NULL,
								Puerta				VARCHAR(100) NULL)
END
ELSE
BEGIN
	DECLARE @Cant_Columnas			SMALLINT
	DECLARE @Flag_Existe_Columna	TINYINT
	
	SET @Cant_Columnas = (SELECT COUNT(*) FROM information_schema.columns WHERE Table_Name = 'CD_Tags_Menor')
	
	IF(@Cant_Columnas <> 3)
	BEGIN	
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags_Menor' AND Column_Name = 'Id_Tag'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags_Menor ADD Id_Tag VARCHAR(20) NOT NULL
		END

		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags_Menor' AND Column_Name = 'Id_Lista_Precio'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags_Menor ADD Id_Lista_Precio	SMALLINT NOT NULL
		END
		
		SET @Flag_Existe_Columna = ISNULL((SELECT 1 FROM information_schema.columns WHERE Table_Name = 'CD_Tags_Menor' AND Column_Name = 'Puerta'), 0)
		IF(@Flag_Existe_Columna = 0)
		BEGIN
			ALTER TABLE CD_Tags_Menor ADD Puerta VARCHAR(100) NULL
		END		
	END
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='zCD_Tags_Menor' AND Xtype='U')
BEGIN
	SELECT *
	INTO zCD_Tags_Menor
	FROM CD_Tags_Menor
END

IF NOT EXISTS(SELECT * FROM Information_Schema.Table_Constraints WHERE Constraint_Name = 'PK_CDTM_PorId' AND Constraint_Type = 'PRIMARY KEY' AND Table_Name = 'CD_Tags_Menor')
BEGIN
	ALTER TABLE CD_Tags_Menor ADD CONSTRAINT PK_CDTM_PorId PRIMARY KEY (Id_Tag)
END

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE name = 'FK_CDTM_Prod_Listas_Precios')
BEGIN
	ALTER TABLE CD_Tags_Menor ADD CONSTRAINT FK_CDTM_Prod_Listas_Precios FOREIGN KEY (Id_Lista_Precio) REFERENCES Prod_Listas_Precios (Id_Lista_Precio)
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE Name='IX_CDTM_PorEve')
BEGIN
	CREATE UNIQUE INDEX IX_CDTM_PorEve ON CD_Tags (Id_Lista_Precio, Id_Tag)
END

GO

/*======================================================================================================================*/